-- change directory to program location
parse source  . . pgm
call directory filespec('L', pgm) 

-- define the source file and import it
infile=.bsf~new("java.io.File", "16-validation result.pdf")
importdoc=BSF.loadClass("org.apache.pdfbox.Loader")
doc=importdoc~loadPDF(infile)

-- configure the signature settings
sigc="org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature"
sig=.bsf~new(sigc)
filter=BSF.loadClass(sigc)~FILTER_ADOBE_PPKLITE
sf=BSF.loadClass(sigc)~SUBFILTER_ADBE_PKCS7_DETACHED
sig~setFilter(filter)
sig~setSubFilter(sf)
sig~setName("Tiao Wang")
sig~setLocation("Vienna, Austria")
sig~setReason("Testing")
cal=BSF.loadClass("java.util.Calendar")~getInstance
sig~setSignDate(cal)
doc~addSignature(sig)

-- prepare the signature generator
password=.bsf~new("java.lang.String", "123456")~toCharArray
keystore=BSF.loadClass("java.security.KeyStore")~getInstance("PKCS12")
ksfis=.bsf~new("java.io.FileInputStream", "resources\keystore.p12")
keystore~load(ksfis,password)
pk=keystore~getKey(test,password)
certchain=keystore~getCertificateChain(test)
certList=BSF.loadClass("java.util.Arrays")~asList(certchain)
cert =certlist~get(0)
certstore=.bsf~new("org.bouncycastle.cert.jcajce.JcaCertStore",certlist)

-- create the signature generator
gen=.bsf~new("org.bouncycastle.cms.CMSSignedDataGenerator")
sbclass="org.bouncycastle.operator.jcajce.JcaContentSignerBuilder"
sha1signer=.bsf~new(sbclass,"SHA256WithRSA")~build(pk)
pbclass="org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder"
calc=.bsf~new(pbclass)~build
igclass="org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder"
infogen=.bsf~new(igclass,calc)~build(sha1signer, cert)
gen~addSignerInfoGenerator(infogen)
gen~addCertificates(certstore)

-- set the destination file
outfile=.bsf~new("java.io.File", "17-signed.pdf")
fos=.bsf~new("java.io.FileOutputStream", outfile)
exsign=doc~saveIncrementalForExternalSigning(fos)

-- convert the signing data to the cms format
x=exsign~getContent
io=BSF.loadClass("org.apache.commons.io.IOUtils")
ba= io~toByteArray(x)
cmsdata=.bsf~new("org.bouncycastle.cms.CMSProcessableByteArray",ba)

-- generate the signature
signed=gen~generate(cmsdata,"false")
cmssig=signed~getEncoded

-- add the signature to the document
exsign~setSignature(cmssig)

-- get java support
::requires "BSF.CLS"